REM  Copyright (c) 1998 by Oracle Corporation 
REM    NAME
REM	MAPISolution.sql - APIs to enables Oracle callouts to MAPI Automation Server
REM    DESCRIPTION
REM		Demonstrate Oracle Database callouts using the COMCartridge to MAPI automation server
REM		Expose a set of calls to
REM		1. Create a MAPI session 
REM		2. Add a new email message
REM		3. Add a recipient to active email
REM		4. Set the subject for active email
REM		5. Set active email message content
REM		6. Send active email
REM		7. End MAPI session
REM
REM    MODIFIED   (MM/DD/YY)
REM     kfleong	   02/11/98 - Creation
REM	klau	   06/01/99 - Expose simple API for sending email
REM	

drop package ORDMapi;
/
CREATE PACKAGE ORDMapi AS


   /* Declare externally callable subprograms. */

	FUNCTION CreateMAPISession (servername IN varchar2 DEFAULT '',
		profilename IN varchar2 DEFAULT NULL, password IN varchar2 DEFAULT NULL) RETURN binary_integer;

	FUNCTION NewMessage RETURN binary_integer;
   
	FUNCTION AddRecipient (emailaddress varchar2) RETURN binary_integer;

	FUNCTION SetSubject (subject varchar2) RETURN binary_integer;

	FUNCTION SetBody (messagetext varchar2) RETURN binary_integer;

	FUNCTION SendMessage RETURN binary_integer;

	FUNCTION EndMAPISession RETURN binary_integer;
	
END ORDMapi;
/

CREATE PACKAGE BODY ORDMapi AS

	i		binary_integer;
	app		binary_integer:=-1;
	message		binary_integer;

PROCEDURE CheckError (message IN VARCHAR2) IS
	error_src		varchar2(255);
	error_description	varchar2(255);
	error_helpfile		varchar2(255);
	error_helpID		binary_integer;
BEGIN
	IF (i!=0) THEN
		ORDCOM.GetLastError(error_src, error_description, error_helpfile, error_helpID);
		dbms_output.put_line(message);
		dbms_output.put_line(error_src);
		dbms_output.put_line(error_description);
		dbms_output.put_line(error_helpfile);
--	ELSE
--		RAISE PROGRAM_ERROR;
	END IF;
END CheckError;



/*******************************************************************************************
 *
 * Creates a MAPI session with the specific profilename 
 *
 *******************************************************************************************/
FUNCTION CreateMAPISession (servername IN varchar2 DEFAULT '',
	profilename IN varchar2 DEFAULT NULL, password IN varchar2 DEFAULT NULL)
RETURN binary_integer IS
	dummy	binary_integer;
BEGIN
	dbms_output.put_line('Creating MAPI Session...');
	i:=ORDCOM.CreateObject('MAPI.Session', 0, servername, app);
	CheckError('Create MAPI Session');
	

	IF (profilename IS NULL) OR (password IS NULL) THEN
		dbms_output.put_line('Logging on...');
		i:=ORDCOM.Invoke(app,'Logon', 0, dummy);
		CheckError('Logon');
	ELSE
		dbms_output.put_line('Logging on...');
		ORDCOM.InitArg();
		ORDCOM.SetArg(profilename,'BSTR');
		ORDCOM.SetArg(password,'BSTR');
		ORDCOM.SetArg(TRUE,'BOOL');  -- [ShowDialog]
		ORDCOM.SetArg(TRUE,'BOOL');  -- [NewSession]
		ORDCOM.SetArg(0, 'I4');	     -- [ParentWindow]
		ORDCOM.SetArg(TRUE, 'BOOL'); -- [NoMail]
		ORDCOM.SetArg(0, 'I4');      -- [ProfileInfo]
		i:=ORDCOM.Invoke(app, 'Logon', 7, dummy);
		CheckError('Logon');
	END IF;
	
	RETURN i;
END CreateMAPISession;


FUNCTION NewMessage RETURN binary_integer IS
	outbox		binary_integer;
	messages	binary_integer;
BEGIN
	dbms_output.put_line('Getting outbox object...');
	i:=ORDCOM.GetProperty(app, 'OutBox', 0,outbox);
	CheckError('Get Outbox');
	
	dbms_output.put_line('Getting message object...');
	i:=ORDCOM.GetProperty(outbox, 'Messages', 0,messages);
	CheckError('Get Outbox.Message');
	
	dbms_output.put_line('Getting message add object...');
	i:=ORDCOM.GetProperty(messages, 'Add', 0,message);
	CheckError ('Add Message');

	RETURN i;	
END NewMessage;


FUNCTION AddRecipient (emailaddress varchar2) RETURN binary_integer IS
	recipients	binary_integer;
	recipient	binary_integer;
BEGIN
	dbms_output.put_line('Getting recipients object...');
	i:=ORDCOM.GetProperty(message, 'Recipients', 0, recipients);
	CheckError ('Get recipients');
	
	dbms_output.put_line('Getting add recipient object...');
	i:=ORDCOM.GetProperty(recipients, 'Add', 0,recipient);
	CheckError ('Add recipient');
	
	dbms_output.put_line('Setting recipient...');
	i:=ORDCOM.SetProperty(recipient, 'Name', emailaddress, 'BSTR');
	CheckError ('Set recipient address');
	
	RETURN i;
END AddRecipient;


FUNCTION SetSubject (subject varchar2) RETURN binary_integer IS
BEGIN
	dbms_output.put_line('Setting subject...');
	i:=ORDCOM.SetProperty(message, 'Subject', subject, 'BSTR');
	CheckError ('Set subject');
	
	RETURN i;
END SetSubject;


FUNCTION SetBody (messagetext varchar2) RETURN binary_integer IS
BEGIN
	dbms_output.put_line('Setting body text...');
	i:=ORDCOM.SetProperty(message, 'Text', messagetext, 'BSTR');
	CheckError ('Set body text');
	
	RETURN i;
END SetBody;

FUNCTION SendMessage RETURN binary_integer IS
	dummy	binary_integer;
BEGIN
	dbms_output.put_line('Sending message...');
	i:=ORDCOM.Invoke(message, 'Send', 0, dummy);
	CheckError ('Send message');
	
	RETURN i;
END SendMessage;

/*******************************************************************************************
 *
 * Call to log off from session
 *
 *
 *******************************************************************************************/
FUNCTION EndMAPISession RETURN binary_integer IS
	dummy binary_integer;
BEGIN
	dbms_output.put_line('Logging off...');
	i:=ORDCOM.Invoke(app, 'Logoff', 0, dummy);
	CheckError ('Log off');
	
	dbms_output.put_line('Close MAPI Session...');
	i:=ORDCOM.DestroyObject(app);
	CheckError ('Close MAPI Session');
	
	RETURN i;
END EndMAPISession;

END ORDMapi;